-- Plot.lua
-- Copyright (c) 2001 Marcio M. Andrade

-- Function plotter.
-- Write the function and limits for x and y axis.
-- Tap Plot to plot the function. Then tap anywhere to return.
-- Select Menu/Stop to stop the application.
-- WARNING: if you write an invalid Lua function, strange things may happen!

ft = "sin(x)"
x0t = "-180"
x1t = "180"
y0t = "-1"
y1t = "1"

function plot(f,x0,x1,y0,y1)
  local x,y,dx,dy,w,h
  w,h = pmode()
  dx,dy = (x1-x0)/w,(y1-y0)/h
  x = 0
  pdestroy()
  pclear()
  pset(0,h-(f(x0)-y0)/dy)
  while x < w do
    y = f(x*dx+x0)
    plineto(x,h-(y-y0)/dy) 
    x = x+1
  end
  pevent()
end

function main()
  pclear()
  pfont(1)
  print("Function Plotter") pnl()

  local ff,x0f,x1f,y0f,y1f,plotb

  pfont(0)
  plabel("f(x) =") ff = pfield(1,24,24,ft) pnl() pnl()

  plabel("x0 =") x0f = pfield(1,4,4,x0t) ptab()
  plabel("x1 =") x1f = pfield(1,4,4,x1t) pnl()
  plabel("y0 =") y0f = pfield(1,4,4,y0t) ptab()
  plabel("y1 =") y1f = pfield(1,4,4,y1t) pnl() pnl()

  plotb = pbutton("Plot") 

  while 1 do
    local e,id = pevent()
    if e == ctlSelect and id == plotb then
      break
    end
  end

  ft = pgettext(ff)
  x0t = pgettext(x0f)
  x1t = pgettext(x1f)
  y0t = pgettext(y0f)
  y1t = pgettext(y1f)

  dostring("function f(x) return "..ft.." end")
  return f, x0t, x1t, y0t, y1t
end

pcolor(255,0)

while 1 do
  local func,x0,x1,y0,y1 = main()
  plot(func,x0,x1,y0,y1)
  pevent()
end
